/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.HMCTimerTask;
import com.ibm.hwmca.fw.util.NamedTimer;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public final class HMCTimer {
    private static HMCTimer theSingleTimer = null;
    private Timer timer = new NamedTimer(true, "Common HMCTimer");

    public static synchronized HMCTimer getHMCTimer() {
        if (theSingleTimer == null) {
            theSingleTimer = new HMCTimer();
        }
        return theSingleTimer;
    }

    private HMCTimer() {
    }

    public void schedule(HMCTimerTask task, long delay) {
        this.timer.schedule(task.isLongRunning() ? new ProxiedTimerTask(task) : task, delay);
    }

    public void schedule(HMCTimerTask task, Date time) {
        this.timer.schedule(task.isLongRunning() ? new ProxiedTimerTask(task) : task, time);
    }

    public void schedule(HMCTimerTask task, long delay, long period) {
        this.timer.schedule(task.isLongRunning() ? new ProxiedTimerTask(task) : task, delay, period);
    }

    public void schedule(HMCTimerTask task, Date firstTime, long period) {
        this.timer.schedule(task.isLongRunning() ? new ProxiedTimerTask(task) : task, firstTime, period);
    }

    public void scheduleAtFixedRate(HMCTimerTask task, long delay, long period) {
        this.timer.scheduleAtFixedRate(task.isLongRunning() ? new ProxiedTimerTask(task) : task, delay, period);
    }

    public void scheduleAtFixedRate(HMCTimerTask task, Date firstTime, long period) {
        this.timer.scheduleAtFixedRate(task.isLongRunning() ? new ProxiedTimerTask(task) : task, firstTime, period);
    }

    class ProxiedTimerTask
    extends TimerTask {
        HMCTimerTask task;

        ProxiedTimerTask(HMCTimerTask task) {
            if (task.proxyTimerTask != null) {
                throw new IllegalStateException("Task already scheduled or cancelled");
            }
            task.setProxy(this);
            this.task = task;
        }

        public void run() {
            if (this.task.activeThreads == 0 || this.task.useMultipleThreads()) {
                ++this.task.activeThreads;
                new Thread(this, "Common HMCTimer service thread for: " + this.task.toString()){
                    private final /* synthetic */ ProxiedTimerTask this$1;
                    {
                        this.this$1 = this$1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            this.this$1.task.run();
                            Object var2_1 = null;
                            --this.this$1.task.activeThreads;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            --this.this$1.task.activeThreads;
                            throw throwable;
                        }
                    }
                }.start();
            }
        }
    }
}

